<?php

namespace Drupal\consent_management;

use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Entity\Routing\AdminHtmlRouteProvider;
use Symfony\Component\Routing\Route;

/**
 * Provides routes for policy version entities.
 *
 * @see \Drupal\Core\Entity\Routing\AdminHtmlRouteProvider
 * @see \Drupal\Core\Entity\Routing\DefaultHtmlRouteProvider
 */
class ConsentManagementPolicyVersionsHtmlRouteProvider extends AdminHtmlRouteProvider {

  /**
   * {@inheritdoc}
   */
  public function getRoutes(EntityTypeInterface $entity_type) {
    $collection = parent::getRoutes($entity_type);

    $entity_type_id = $entity_type->id();


    if ($route = $collection->get('entity.cm_policy_version.edit_form')) {

      $options = [
        'parameters' => [
          'cm_policy' => [
            'type' => 'entity:cm_policy',
            'converter' => 'paramconverter.entity'
          ],
          'cm_policy_version' => [
            'type' => 'entity:cm_policy_version',
            'converter' => 'paramconverter.entity'
          ]
        ],
      ];

      $route->setOptions($options);


      $collection->add('entity.cm_policy_version.edit_form', $route);

    }

    return $collection;
  }


}
