<?php

namespace Drupal\consent_management;

use Drupal\consent_management\Entity\UserConsentInterface;

/**
 * Defines the Data Policy Consent Manager service interface.
 */
interface ConsentManagerInterface {

  /**
   * Check if user gave consent on a current version of data policy.
   *
   * @return bool
   *   TRUE if consent is needed.
   */
  public function needConsent();

  /**
   * Add checkbox to form which allow user give consent on data policy.
   *
   * @param array $form
   *   An associative array containing the structure of the form.
   */
  public function addCheckbox(array &$form);

  /**
   * Save user consent.
   *
   * @param int $user_id
   *   The user ID.
   * @param string $action
   *   The action (submit and etc.)
   * @param array $values
   *   Array of user consent values to process saveConsent:
   *   - state - required option,
   *   - entity_id - required option,
   *   The one of three allowed states:
   *   - undecided,
   *   - not agree,
   *   - agree.
   */
  public function saveConsent($user_id, $action = NULL, array $values = ['state' => UserConsentInterface::STATE_UNDECIDED]);

  /**
   * Get existing user consents.
   *
   * @param int $user_id
   *   The user ID.
   *
   * @return array
   *   The array of existing consents.
   */
  public function getExistingUserConsents($user_id);

  /**
   * Check if data policy is created.
   *
   * @return bool
   *   TRUE if data policy entity is created.
   */
  public function isDataPolicy();

  /**
   * {@inheritdoc}
   */
  public function isRequiredDataPolicies(): bool;

}
