<?php

declare(strict_types=1);

namespace Drupal\consent_management\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\Session\AccountProxyInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Url;
use Drupal\Core\Routing\CurrentRouteMatch;
use Drupal\Core\Entity\EntityInterface;

/**
 * Returns responses for Consent Management routes.
 */
final class ConsentManagementPolicyVersionsController extends ControllerBase {

  /**
   * The controller constructor.
   */
  public function __construct(
    EntityTypeManagerInterface $entity_type_manager,
    readonly CurrentRouteMatch $currentRouteMatch,
  ) {
    $this->entityTypeManager = $entity_type_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): self {
    return new self(
      $container->get('entity_type.manager'),
      $container->get('current_route_match')      
    );
  }

  /**
   * Builds the response.
   */
  public function __invoke(): array {


    $cm_policy = $this->currentRouteMatch->getParameter('cm_policy');

    if (!$cm_policy instanceof EntityInterface) {
      $cm_policy = $this->entityTypeManager->getStorage('cm_policy')->load($cm_policy);
    }

    $build = [];

    $url_add_policy = Url::fromRoute(
      'entity.cm_policy_version.add_form', [
        'cm_policy' => $cm_policy->id(),
      ],
      [
        'query' => \Drupal::destination()->getAsArray()
      ]
    );

    $link_add_policy_version = [
      '#type' => 'link',
      '#url' => $url_add_policy,
      '#title' => $this->t('Add Policy version'),
      '#attributes' => ['class' => ['button', 'btn']],
    ];

    $url_policy_collection = Url::fromRoute('entity.cm_policy.collection',[]);

    $link_policy_overview = [
      '#type' => 'link',
      '#url' => $url_policy_collection,
      '#title' => $this->t('Back to policies'),
      '#attributes' => ['class' => ['button', 'btn']],
    ];

    $build['add_policy_link'] = $link_add_policy_version;

    $build['policies_link'] = $link_policy_overview;

    $list_builder = $this->entityTypeManager->getListBuilder('cm_policy_version');
    $build['content'] = $list_builder->render();

    return $build;

  }

}
