<?php

declare(strict_types=1);

namespace Drupal\consent_management\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Consent Management settings for this site.
 */
final class MigrationSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'consent_management_migration_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['consent_management.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $form['example'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Example'),
      '#default_value' => $this->config('consent_management.settings')->get('example'),
    ];
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state): void {
    // @todo Validate the form here.
    // Example:
    // @code
    //   if ($form_state->getValue('example') === 'wrong') {
    //     $form_state->setErrorByName(
    //       'message',
    //       $this->t('The value is not correct.'),
    //     );
    //   }
    // @endcode
    parent::validateForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
  
    $data_policies = \Drupal::entityTypeManager()->getStorage('data_policy')->loadMultiple();
    
    foreach ($data_policies as $data_policy) {
      $entity_id = $data_policy->id();
      
      $latest_vid = \Drupal::entityTypeManager()
        ->getStorage('data_policy')
        ->getLatestRevisionId($entity_id);
      dump($latest_vid);  
      
      dump($entity_id);
      
      
      $vids = \Drupal::entityTypeManager()->getStorage('data_policy')->revisionIds($data_policy);    
      
      dump($vids);
      
      exit;
      
 
    }
  
  
  /*
    $this->config('consent_management.settings')
      ->set('example', $form_state->getValue('example'))
      ->save();
    parent::submitForm($form, $form_state);
  */
  }

}
