<?php

declare(strict_types=1);

namespace Drupal\consent_management\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

/**
 * Form controller for the policy version entity edit forms.
 */
final class PolicyVersionForm extends ContentEntityForm {

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state): int {
    $result = parent::save($form, $form_state);

    $message_args = ['%label' => $this->entity->label()];
    $logger_args = [
      '%label' => $this->entity->label(),
      'link' => $this->entity->label(),
    ];

    switch ($result) {
      case SAVED_NEW:
        $this->messenger()->addStatus($this->t('New policy version %label has been created.', $message_args));
        $this->logger('consent_management')->notice('New policy version %label has been created.', $logger_args);
        break;

      case SAVED_UPDATED:
        $this->messenger()->addStatus($this->t('The policy version %label has been updated.', $message_args));
        $this->logger('consent_management')->notice('The policy version %label has been updated.', $logger_args);
        break;

      default:
        throw new \LogicException('Could not save the entity.');
    }


    $url = Url::fromRoute('consent_management.consent_management_policy_versions', [
      'cm_policy' => $this->entity->getPolicyId(),
    ]);

    $form_state->setRedirectUrl($url);

    return $result;
  }

}
