<?php

namespace Drupal\consent_management\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FormatterBase;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\consent_management\UserConsentInterface;
use Drupal\Core\Render\Markup;
use Drupal\Core\Url;
use Drupal\Core\Link;

/**
 * Plugin implementation of the 'state text' formatter.
 *
 * @FieldFormatter(
 *   id = "modal_dialog_policy",
 *   label = @Translation("Policy Version History Modal Dialog Link"),
 *   field_types = {
 *     "integer"
 *   }
 * )
 */
class ModalDialogPolicyHistoryFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public function settingsSummary() {
    $summary = [];
    $summary[] = $this->t('Displays a modal dialog link from a policy version field.');
    return $summary;
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $element = [];

    foreach ($items as $delta => $item) {
      // Render each element as markup.
      $element[$delta] = ['#markup' => $this->getLink($item->value)];
    }

    return $element;
  }

  /**
   * {@inheritdoc}
   */
  public static function isApplicable(FieldDefinitionInterface $field_definition): bool {
    $field_name = $field_definition->getName();
    return ($field_name == 'id');
  }  

  protected function getLink($value) {

    $policies = \Drupal::entityTypeManager()->getStorage('cm_policy')->loadByProperties(['cm_policy_version' => $value]);
    if ($policy = reset($policies)) {
      $policy_id = $policy->id();
    }    
    
    // Define destination
    $destination = Url::fromRoute('view.consent_management_user_consent_report.page')->toString();

    // Define link options
    $options = [
      'query' => [
        'display' => 'modal_dialog',
        'destination' => $destination,
        'user' => $entity->getOwnerId(),
      ]
    ];
    
      $url = Url::fromRoute('view.consent_management_user_history_report.page', [], $options);

      // Link title
      $link_title = t('History');  


    $link = [
      '#type' => 'link',
      '#title' => $link_title,
      '#url' => $url,
      '#ajax' => [
        'dialogType' => 'dialog',
        'dialog' => ['height' => 600, 'width' => 1000, 'title' => 'TEST!!!'],
      ],
      '#attributes' => ['class' => ['button', 'btn', 'button--small', 'btn--small']]
    ]; 
     


    //$field_output['#attached']['library'][] = 'apprenticeship_admin/icon_design';
    $field_output['field'] = 'test';
 

    $output = \Drupal::service('renderer')->render($field_output);  

    return $link->toString();

  }

}