<?php

namespace Drupal\consent_management\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FormatterBase;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\consent_management\UserConsentInterface;

/**
 * Plugin implementation of the 'state text' formatter.
 *
 * @FieldFormatter(
 *   id = "state_text",
 *   label = @Translation("State text"),
 *   field_types = {
 *     "integer"
 *   }
 * )
 */
class UserConsentStateTextFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public function settingsSummary() {
    $summary = [];
    $summary[] = $this->t('Displays the state as text.');
    return $summary;
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $element = [];

    foreach ($items as $delta => $item) {
      // Render each element as markup.
      $element[$delta] = ['#markup' => $this->getText($item->value)];
    }

    return $element;
  }

  /**
   * {@inheritdoc}
   */
  public static function isApplicable(FieldDefinitionInterface $field_definition): bool {
    $field_name = $field_definition->getName();
    return ($field_name == 'state');
  }  

  protected function getText($value) {

    $text = $value;

    if ($value == 0) {
      $text = $this->t('undecided');
    }
    elseif ($value == 1) {
      $text = $this->t('not agreed');  
    }
    elseif ($value == 2) {
      $text = $this->t('agreed');  
    }

    return $text;

  }

}