<?php

declare(strict_types=1);

namespace Drupal\consent_management\Plugin\QueueWorker;

use Drupal\consent_management\Helper;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Queue\QueueWorkerBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Defines 'consent_management_user_consent_policy_version_sync' queue worker.
 *
 * @QueueWorker(
 *   id = "consent_management_user_consent_policy_version_sync",
 *   title = @Translation("User consent policy version sync"),
 *   cron = {"time" = 60},
 * )
 */
final class UserConsentPolicyVersionSync extends QueueWorkerBase implements ContainerFactoryPluginInterface {

  /**
   * Constructs a new UserConsentPolicyVersionSync instance.
   */
  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    private readonly Helper $consentManagementHelper,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): self {
    return new self(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('consent_management.helper'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function processItem($data): void {
    // @todo Process data here.
    
  }

}
