<?php

namespace Drupal\consent_management\Plugin\views\field;

use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;
use Drupal\Core\Url;
use Drupal\Core\Link;
use Drupal\consent_management\PolicyInterface;
use Drupal\consent_management\PolicyVersionInterface;
use Drupal\consent_management\UserConsentInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\user\UserInterface;
use Drupal\Core\Render\Markup;

/**
 * Field handler to flag the node type.
 *
 * @ingroup views_field_handlers
 *
 * @ViewsField("modal_dialog_policy_versions")
 */
class ModalDialogPolicyVersions extends FieldPluginBase {

  /**
   * @{inheritdoc}
   */
  public function query() {
    // Leave empty to avoid the field being used in the query.
  }

  /**
   * Define the available options
   * @return array
   */
  protected function defineOptions() {    
    $options = parent::defineOptions(); 
    return $options;
  }  


  /**
   * {@inheritdoc}
   */
  public function buildOptionsForm(&$form, FormStateInterface $form_state) {
    parent::buildOptionsForm($form, $form_state);
  }  

  /**
   * @{inheritdoc}
   */
  public function render(ResultRow $values) {

    $url = [];
    $entity = $this->getEntity($values);

    //$policy_id = $values->cm_policy_field_data_cm_policy_version_field_data_id;

    $entity_type_id = $entity->getEntityTypeId();


    $link_title = '';
    
    $policy_id = NULL;

    if (!$entity instanceof UserInterface)  {     
      return;
    }    

    // Define destination
    $destination = \Drupal::destination()->getAsArray();

    // Define link options
    $options = [
      'query' => [
        'display' => 'modal_dialog',
        'user' => $entity->id(),
        $destination
      ]
    ];
    
      $url = Url::fromRoute('view.consent_management_user_history_report.page',[], $options);

      // Link title
      $link_title = t('History Report');  
      // Modal title
      $modal_title = $this->t('History Report for @username' , ['@username' => $entity->getDisplayName()]); 


    $field['link'] = [
      '#type' => 'link',
      '#title' => $link_title,
      '#url' => $url,
      '#ajax' => [
        'dialogType' => 'dialog',
        'dialog' => ['height' => 600, 'width' => 1000, 'title' => $modal_title],
      ],
      '#attributes' => ['class' => ['button', 'btn', 'button--small', 'btn--small']]
    ]; 
     


    //$field_output['#attached']['library'][] = 'apprenticeship_admin/icon_design';
    $field_output['field'] = $field;
 

    $output = \Drupal::service('renderer')->render($field_output);  

    return $output;

  }




}
