<?php

namespace Drupal\consent_management\Plugin\views\field;

use Drupal\Component\Utility\Xss as UtilityXss;
use Drupal\Core\Form\FormStateInterface;
use Drupal\views\Attribute\ViewsField;
use Drupal\views\Render\ViewsRenderPipelineMarkup;
use Drupal\views\ResultRow;
use Drupal\views\ViewExecutable;
use Drupal\views\Plugin\views\display\DisplayPluginBase;
use Drupal\views\Plugin\views\field\FieldPluginBase;

/**
 * Field handler to show user consent states.
 *
 * @ingroup views_field_handlers
 *
 * @ViewsField("user_consent_state")
 */
class UserConsentState extends FieldPluginBase {

  /**
   * The allowed formats.
   */
  public array $formats;

  /**
   * {@inheritdoc}
   */
  protected function defineOptions() {
    $options = parent::defineOptions();
    return $options;
  }



  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {
    $value = $this->getValue($values);
    
    if ($value == 0) {
      $text = $this->t('undecided');
    }
    elseif ($value == 1) {
      $text = $this->t('not agreed');  
    }
    elseif ($value == 2) {
      $text = $this->t('agreed');  
    }
    else {
      $text = '-';
    }

    return $text;

  }

}
