<?php

declare(strict_types=1);

namespace Drupal\consent_management;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface defining a policy entity type.
 */
interface PolicyInterface extends ContentEntityInterface, EntityOwnerInterface, EntityChangedInterface {

  /**
   * {@inheritdoc}
   */
  public function getPolicyVersionId();

  /**
   * {@inheritdoc}
   */
  public function setPolicyVersionId($policy_version_id);

  /**
   * {@inheritdoc}
   */
  public function getPolicyVersion();

  /**
   * {@inheritdoc}
   */
  public function getConsentFormula();

  /**
   * {@inheritdoc}
   */
  public function setConsentFormula(string $consent_formula);

  /**
   * {@inheritdoc}
   */
  public function getPolicyRequired();

  /**
   * {@inheritdoc}
   */
  public function setPolicyRequired(bool $policy_required);

  /**
   * {@inheritdoc}
   */
  public function getUserRoles();

  /**
   * {@inheritdoc}
   */
  public function getStatus();

  /**
   * {@inheritdoc}
   */
  public function setStatus($status);
  
}
