<?php

declare(strict_types=1);

namespace Drupal\consent_management;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface defining a policy version entity type.
 */
interface PolicyVersionInterface extends ContentEntityInterface, EntityOwnerInterface, EntityChangedInterface {

  /**
   * {@inheritdoc}
   */
  public function getPolicyId();
  
  /**
   * {@inheritdoc}
   */
  public function setPolicyId($policy_id);


  /**
   * {@inheritdoc}
   */
  public function getPolicy();

  /**
   * {@inheritdoc}
   */
  public function getStatus();

  /**
   * {@inheritdoc}
   */
  public function setStatus($status);

}
