<?php

namespace Drupal\consent_management;

use Drupal\views\EntityViewsData;

/**
 * Provides Views data for User Consent entities.
 */
class UserConsentViewsData extends EntityViewsData {

  /**
   * {@inheritdoc}
   */
  public function getViewsData() {
    $data = parent::getViewsData();





    // Fields.
    $data['cm_user_consent']['state'] = [
      'title' => t('Consent State'),
      'help' => t('Consent State.'),
      'field' => [
        'id' => 'user_consent_state',
      ],
      'sort' => [
        'id' => 'standard',
      ],
      'filter' => [
        'id' => 'string',
      ],
      'argument' => [
        'id' => 'string',
      ],
    ]; 

 

    $data['cm_user_consent']['meta_user_id'] = [
      'title' => t('META user id'),
      'help' => t('META info about user.'),
      'field' => [
        'id' => 'standard',
      ],
      'sort' => [
        'id' => 'standard',
      ],
      'filter' => [
        'id' => 'number',
      ],
      'argument' => [
        'id' => 'number',
      ],
    ];     

    $data['cm_user_consent']['meta_user_name'] = [
      'title' => t('Meta username'),
      'help' => t('META info about user.'),
      'field' => [
        'id' => 'standard',
      ],
      'sort' => [
        'id' => 'standard',
      ],
      'filter' => [
        'id' => 'string',
      ],
      'argument' => [
        'id' => 'string',
      ],
    ];    
    
    $data['cm_user_consent']['meta_user_mail'] = [
      'title' => t('Meta user email.'),
      'help' => t('META info about user.'),
      'field' => [
        'id' => 'standard',
      ],
      'sort' => [
        'id' => 'standard',
      ],
      'filter' => [
        'id' => 'string',
      ],
      'argument' => [
        'id' => 'string',
      ],
    ];      

    $data['cm_user_consent']['meta_user_created'] = [
      'title' => t('Meta user created.'),
      'help' => t('META info about user.'),
      'field' => [
        'id' => 'date',
      ],
      'sort' => [
        'id' => 'date',
      ],
      'filter' => [
        'id' => 'date',
      ],
      'argument' => [
        'id' => 'date',
      ],
    ];   
    
    $data['cm_user_consent']['meta_user_cancelled'] = [
      'title' => t('Meta user cancelled.'),
      'help' => t('META info about user.'),
      'field' => [
        'id' => 'date',
      ],
      'sort' => [
        'id' => 'date',
      ],
      'filter' => [
        'id' => 'date',
      ],
      'argument' => [
        'id' => 'date',
      ],
    ];       

 
    
    $data['cm_user_consent']['id'] = [
      'title' => t('ID'),
      'help' => t('User consent ID.'),
      'field' => [
        'id' => 'standard',
      ],
      'sort' => [
        'id' => 'standard',
      ],
      'filter' => [
        'id' => 'string',
      ],
      'argument' => [
        'id' => 'string',
      ],
    ];      

    $data['users_field_data']['modal_dialog_policy_versions'] = array(
      'title' => t('Modal Dialog Policy Versions'),
      'group' => t('Policy Version History Dialog'),
      'field' => array(
        'title' => t('History Policy versions'),
        'help' => t('History Policy versions.'),
        'id' => 'modal_dialog_policy_versions',
      ),
    );  

    $data['users_field_data']['cm_user_consent_field']['relationship'] = [
      'title' => $this->t('Related user consent'),
      'help' => $this->t('Relate user to user consent.'),
      'base' => 'cm_user_consent',
      'base field' => 'uid',
      'field' => 'uid',
      // ID of relationship handler plugin to use.
      'id' => 'standard',
      // Default label for relationship in the UI.
      'label' => $this->t('Related user consent'),
    ];    

    $data['cm_user_consent']['cm_policy_version']['relationship'] = [
      'title' => $this->t('Related policy version'),
      'help' => $this->t('Relate user consent to policy versions.'),
      'base' => 'cm_policy_version_field_data',
      'base field' => 'id',
      // ID of relationship handler plugin to use.
      'id' => 'standard',
      // Default label for relationship in the UI.
      'label' => $this->t('Related policy version'),
    ];

    $data['users_field_data']['policy_user_consent_state'] = array(
      'title' => t('User consent state for Policy'),
      'group' => t('User consent'),
      'field' => array(
        'title' => t('Policy user consent state'),
        'help' => t('Policy user consent state'),
        'id' => 'current_policy_state',
        'click sortable' => FALSE,
      ),
    );


    return $data;

  }


}
