<?php

namespace Drupal\consent_validator\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\webform\Entity\Webform;

/**
 *
 */
class ConsentValidatorSettingsForm extends ConfigFormBase {

  /**
   *
   */
  protected function getEditableConfigNames() {
    return ['consent_validator.settings'];
  }

  /**
   *
   */
  public function getFormId() {
    return 'consent_validator_settings_form';
  }

  /**
   *
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('consent_validator.settings');

    // Load all webforms.
    $webforms = Webform::loadMultiple();
    $options = [];

    foreach ($webforms as $id => $webform) {
      $options[$id] = $webform->label();
    }

    $form['enabled_webforms'] = [
      '#type' => 'checkboxes',
      '#title' => $this->t('Enable consent validation for these webforms'),
      '#options' => $options,
      '#default_value' => $config->get('enabled_webforms') ?? [],
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   *
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('consent_validator.settings')
      ->set('enabled_webforms', array_filter($form_state->getValue('enabled_webforms')))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
