# Constructor - Профіль встановлення Drupal 11

Налаштовуваний профіль встановлення Drupal 11 з багатокроковим майстром налаштування для конфігурації мов, типів контенту, модулів, макету та інтеграції з ШІ.

## Скріншоти

### Майстер встановлення
![Майстер встановлення](installer.png)

### Дизайн фронтенду
![Дизайн фронтенду](design.jpg)

## Можливості

- **Багатокроковий майстер встановлення**: 7-крокове керівництво
  - Вибір мови: Виберіть мову встановлення
  - Налаштування бази даних: Конфігурація підключення до БД
  - Основи сайту: Назва, обліковий запис адміністратора, email, опис
  - Мови: Багатомовна підтримка з перекладом контенту та інтерфейсу
  - Типи контенту: Попередньо налаштовані типи з полями
  - Дизайн і макет: Налаштування теми та блоків
  - Інтеграція з ШІ: Генерація контенту на базі OpenAI

- **Власні модулі**:
  - **OpenAI Provider**: Генерація контенту з GPT та DALL-E
  - **Simple Metatag**: SEO метатеги з підтримкою Google Tag
  - **Simple Sitemap Generator**: XML карти сайту з підтримкою мультидоменів
  - **Content FAQ**: Тип контенту FAQ з блоком-акордеоном
  - **Content Team**: Тип контенту для команди з каруселлю
  - **Content Services**: Тип контенту для послуг з блоком методів
  - **Content Article**: Тип контенту для статей з підтримкою відео
  - **Content Commerce**: Тип контенту для товарів з блоками електронної комерції
  - **Language Switcher**: Модальне вікно/панель вибору мови
  - **Constructor Hero**: Налаштовувані блоки Hero, What We Do, Booking Modal
  - **Form Sender**: Універсальний API для відправки форм через Email та Telegram
  - **Contact Form**: Блок контактної форми з картою та повідомленням про успіх
  - **Gallery**: Галерея зображень з адмін-інтерфейсом та лайтбоксом PhotoSwipe
  - **Pricing Plans**: Тарифні плани з налаштовуваним блоком та інтеграцією Form Sender

- **Попередньо налаштовані модулі ядра**:
  - Pathauto: Автоматичне створення URL-псевдонімів
  - Views: Списки та відображення контенту
  - Media: Керування медіабібліотекою
  - Content Translation: Підтримка багатомовного контенту

- **Готовність до розробки**:
  - Агрегація CSS/JS вимкнена за замовчуванням
  - Режим налагодження Twig увімкнено
  - Усе кешування вимкнено (рендер, сторінки, динамічне)
  - Текстовий формат Full HTML включено

- **Власна тема**: Сучасна адаптивна тема на Tailwind CSS v4
  - Підтримка темного режиму (перемикання на основі класу)
  - Повне перевизначення шаблонів для чистого HTML
  - Інтеграція відеоплеєра Plyr
  - Каруселі Swiper.js
  - Лайтбокс PhotoSwipe
  - Mobile-first адаптивний дизайн
  - Власні контрольні точки (3xl: 1920px, 4xl: 2560px, 5xl: 3200px)

- **Багатомовна підтримка**:
  - Українські переклади для всіх власних модулів
  - Переклад інтерфейсу
  - Переклад контенту з автоматичним перекладом на базі ШІ

## Вимоги

- PHP 8.3 або вище
- MySQL 8.0 або MariaDB 10.6+
- Composer 2.x
- Node.js 22+ (для Tailwind CSS v4)
- Lando (для локальної розробки)

## Встановлення

### Використання Lando (рекомендовано)

1. Клонуйте репозиторій:
   ```bash
   git clone https://github.com/kindrakevich-agency/constructor.git
   cd constructor
   ```

2. Запустіть Lando:
   ```bash
   lando start
   ```

3. Встановіть залежності Composer:
   ```bash
   lando composer install
   ```

4. Перейдіть на сайт: https://constructor.lndo.site та слідуйте майстру встановлення

   Або встановіть через CLI:
   ```bash
   lando drush site:install constructor --yes --account-name=admin --account-pass=admin
   ```

### Розробка теми

1. Перейдіть до директорії теми:
   ```bash
   cd web/themes/custom/constructor_theme
   ```

2. Встановіть залежності Node:
   ```bash
   npm install
   ```

3. Зберіть CSS (використовуйте Node 22+):
   ```bash
   nvm use 22
   npm run build
   ```

4. Спостереження за змінами (розробка):
   ```bash
   npm run watch
   ```

## Структура проекту

```
constructor/
├── .lando.yml                    # Конфігурація Lando
├── .lando/
│   ├── php.ini                   # Конфігурація PHP (таймаути, пам'ять)
│   └── nginx.conf                # Конфігурація Nginx (таймаути)
├── composer.json                 # PHP залежності
├── web/
│   ├── modules/
│   │   └── custom/
│   │       ├── constructor_hero/         # Модуль блоків Hero
│   │       ├── contact_form/             # Модуль блоку контактної форми
│   │       ├── content_article/          # Модуль типу контенту Стаття
│   │       ├── content_commerce/         # Модуль Товарів
│   │       ├── content_faq/              # Модуль типу контенту FAQ
│   │       ├── content_services/         # Модуль типу контенту Послуги
│   │       ├── content_team/             # Модуль типу контенту Команда
│   │       ├── form_sender/              # API відправки форм (Email/Telegram)
│   │       ├── gallery/                  # Галерея зображень з адміном
│   │       ├── language_switcher/        # Блок перемикача мов
│   │       ├── openai_provider/          # Інтеграція OpenAI
│   │       ├── pricing_plans/            # Блок тарифних планів
│   │       ├── simple_metatag/           # SEO модуль
│   │       └── simple_sitemap_generator/ # Модуль карти сайту
│   ├── profiles/
│   │   └── custom/
│   │       └── constructor/              # Профіль встановлення
│   │           ├── config/install/       # Конфігурації за замовчуванням
│   │           ├── themes/
│   │           │   └── constructor_install/  # Тема інсталятора
│   │           ├── translations/         # Переклади профілю
│   │           └── src/Form/             # Класи форм майстра
│   └── themes/
│       └── custom/
│           └── constructor_theme/        # Власна фронтенд тема
│               ├── css/                  # Зібраний CSS
│               ├── js/                   # JavaScript файли
│               ├── src/input.css         # Джерело Tailwind
│               ├── translations/         # Переклади теми
│               └── templates/            # Twig шаблони
└── README.md
```

## Власні модулі

### Constructor Hero
Надає налаштовувані hero-блоки:
- **Hero Block**: Повноширинний hero з заголовком, описом, формою введення, статистикою, рейтингом, зображенням
  - Форма введення з опціями "Заповнити email" або "Заповнити телефон" - попередньо заповнює форму бронювання
  - Опція "Показати кнопку в шапці" - відображає CTA кнопку в шапці (десктоп і мобільний)
- **What We Do Block**: Секція з бейджем, заголовком, описом, CTA кнопками
- **Booking Modal Block**: Налаштовуване модальне вікно форми бронювання
  - Поля: Ім'я, Email, Телефон, Повідомлення (поле Компанія доступне, але приховане за замовчуванням)
  - Автозаповнення з Hero Block при натисканні на CTA кнопку

Усі елементи налаштовуються через параметри блоку в адмін-інтерфейсі.

### Content Article
- Тип контенту Стаття з полями body, image та YouTube video URL
- **Articles Block**: Сітка останніх статей з мініатюрами відео
- **Article Video Block**: Повноширинний банер для статей з відео
- Сторінка списку статей на `/articles`
- Сторінка статті з відеоплеєром Plyr

### Content Commerce
- Тип контенту Товар з кількома зображеннями, ціною, кольорами, розмірами
- Таксономія категорій товарів
- Налаштування комерції (валюта, інформація про доставку)
- **Product Carousel Block**: Слайдер товарів на Swiper з банером колекції
- **Product Sale Hero Block**: Рекламний банер "Найгарячіша пропозиція"
- **Single Product Block**: Деталі товару з галереєю, вибором кольору та розміру
- **Products List Block**: Фільтри категорій, картки, сітка товарів
- Сторінка списку товарів на `/products`
- Сторінки категорій товарів на `/products/{назва-категорії}` (напр., `/products/accessories`)

### Content FAQ
- Тип контенту FAQ з полями питання/відповідь
- FAQ Block з акордеоном
- Сторінка FAQ з CTA контакту

### Content Services
- Тип контенту Послуга з описом та іконкою
- Services Block для списку послуг
- Service Methods Block із зображенням та функціями

### Content Team
- Тип контенту Член команди з фото, посадою, біографією
- Team Block з каруселлю
- Сторінка списку команди

### Form Sender
Універсальний API для відправки даних форм:
- Відправка email з налаштовуваним отримувачем та префіксом теми
- Інтеграція з Telegram Bot API
- Сторінка налаштувань на `/admin/config/services/form-sender`
- Функція тестової відправки
- Використання: `\Drupal::service('form_sender')->send($data)`

### Contact Form
Блок контактної форми з:
- Налаштовуваним заголовком (назва, підзаголовок, опис)
- Полями: Ім'я, Email, Компанія, Тема, Повідомлення
- Захист від спаму honeypot (без CAPTCHA)
- Секція контактної інформації (телефон, email, години роботи)
- Інтерактивна карта OpenStreetMap з налаштовуваними координатами
- Картка адреси офісу з посиланням на маршрут
- Модальне вікно успіху (десктоп) / панель (мобільний) у стилі перемикача мови
- Чистий JavaScript для відправки форми через JSON API (без jQuery)

### Gallery
Модуль галереї зображень з:
- Адмін-інтерфейс на `/admin/content/gallery` (вкладка під Контентом)
- Форма додавання зображень з керованим завантаженням файлів
- Список зображень з мініатюрами, alt-текстом, датою, кнопкою видалення
- **Gallery Block**: Налаштовуваний блок з міткою, заголовком, описом, CTA кнопкою
- Сторінка галереї на `/gallery` з усіма зображеннями
- Інтеграція лайтбоксу PhotoSwipe для повноекранного перегляду
- Приклади зображень створюються під час встановлення

### Pricing Plans
Модуль тарифних планів з:
- Тип контенту Тарифний план (назва, ціна, період, функції, прапорець рекомендовано)
- **Pricing Block**: Налаштовуване відображення карток тарифів
- Інтеграція Form Sender для вибору плану
- Модальне вікно/панель успіху при відправці форми
- Приклади планів (Basic, Pro, Enterprise) створюються під час встановлення
- Українські переклади включені

### Language Switcher
- Модальне вікно вибору мови (десктоп)
- Панель вибору мови (мобільний)
- Автоматичне розміщення в шапці та підвалі

### OpenAI Provider
- Генерація тексту GPT
- Генерація зображень DALL-E
- Форма налаштувань для конфігурації API
- Форма тестування для перевірки API

### Simple Metatag
- Автоматична генерація метатегів для нод і термінів
- Перевизначення метатегів на основі шляху
- Інтеграція Google Tag (gtag.js)
- Підтримка мультидоменів (з модулем Domain)

### Simple Sitemap Generator
- Генерація XML карти сайту
- Підтримка мультидоменів
- Власні URL
- Налаштовувані типи контенту
- Керування кешем

## Команди Lando

| Команда | Опис |
|---------|------|
| `lando start` | Запустити середовище Lando |
| `lando stop` | Зупинити середовище Lando |
| `lando rebuild` | Перебудувати середовище Lando |
| `lando drush <cmd>` | Виконати команди Drush |
| `lando composer <cmd>` | Виконати команди Composer |
| `lando mysql` | Доступ до MySQL CLI |

## Підключення до бази даних

### Внутрішнє (з контейнерів Lando)
| Налаштування | Значення |
|--------------|----------|
| Хост | `database` |
| Порт | `3306` |
| База даних | `drupal` |
| Користувач | `drupal` |
| Пароль | `drupal` |

### Зовнішнє (з хост-машини)
| Налаштування | Значення |
|--------------|----------|
| Хост | `127.0.0.1` |
| Порт | Виконайте `lando info` для поточного порту |
| База даних | `drupal` |
| Користувач | `drupal` |
| Пароль | `drupal` |

## Кроки майстра встановлення

### Крок 1: Вибір мови
- Виберіть мову встановлення (English, Ukrainian тощо)

### Крок 2: Налаштування бази даних
- Конфігурація підключення до бази даних

### Крок 3: Основи сайту
- Назва та слоган сайту
- Email сайту
- Обліковий запис адміністратора (ім'я, email, пароль)

### Крок 4: Мови
- Увімкнення багатомовної підтримки
- Додавання додаткових мов
- Налаштування перекладу контенту

### Крок 5: Типи контенту
- Вибір з попередньо налаштованих типів контенту:
  - Базова сторінка
  - Стаття (з підтримкою відео)
  - Член команди
  - FAQ
  - Послуга
  - Товар (електронна комерція)
  - Галерея
  - Тарифні плани

### Крок 6: Інтеграція з ШІ
- Налаштування API ключа OpenAI
- Вибір моделі для генерації тексту (GPT-4o, GPT-4 тощо)
- Перемикач генерації зображень (генерація ШІ-зображень для контенту, увімкнено за замовчуванням)
- Налаштування моделі та якості зображень
- Автоматична генерація контенту для всіх увімкнених типів

**Примітка:** Темний режим увімкнено за замовчуванням у налаштуваннях теми. Змінити можна за адресою `/admin/appearance/settings/constructor_theme`.

## Функції теми

### Tailwind CSS v4
Тема використовує Tailwind CSS v4 зі standalone CLI:
- Підтримка CSS nesting
- Темний режим на основі класу через `@variant dark`
- Власні стилі компонентів
- Власні контрольні точки для великих екранів

### Структура шаблонів
Усі шаблони Drupal перевизначені для чистого HTML:
- Мінімальні обгорткові елементи
- Семантична структура HTML5
- Utility-класи Tailwind

### Темний режим
Перемикайте темний режим додаванням/видаленням класу `dark` на елементі `<html>`.
Кнопка перемикання теми включена в шапку.

### Налаштування теми
Налаштуйте тему за адресою `/admin/appearance/settings/constructor_theme`:

**Налаштування темного режиму**
- Увімкнення/вимкнення кнопки перемикання темного режиму в шапці

**Контактна інформація**
- Номер телефону (відображається в мобільному меню та підвалі)
- Email адреса (відображається в мобільному меню та підвалі)
- Слоган підвалу (текст опису під логотипом у підвалі)

**Соціальні посилання**
- URL Twitter/X
- URL GitHub
- URL LinkedIn
- URL Instagram

Усі соціальні посилання необов'язкові - залиште порожніми, щоб приховати.

## Переклади

Українські переклади включені для:
- Усіх власних модулів
- Теми Constructor
- Профілю встановлення

Переклади **автоматично імпортуються під час встановлення** при виборі додаткових мов.

Для ручного імпорту перекладів:
```bash
lando drush locale:import uk /app/web/modules/custom/MODULE_NAME/translations/uk.po --override=all
```

## Розробка

### Збірка CSS теми
```bash
cd web/themes/custom/constructor_theme
nvm use 22
npm run build
```

### Очищення кешу
```bash
lando drush cr
```

### Перегляд логів
```bash
lando drush watchdog:show
```

## Вирішення проблем

### Поширені проблеми

1. **504 Gateway Timeout під час встановлення**: Встановлення з генерацією контенту ШІ може тривати кілька хвилин. Конфігурація Lando включає розширені таймаути (10 хвилин) для nginx та PHP. Якщо все ще отримуєте таймаути:
   ```bash
   lando rebuild -y
   ```

2. **Версія Node.js**: Tailwind CSS v4 потребує Node.js 22+. Використовуйте nvm для перемикання:
   ```bash
   nvm use 22
   ```

3. **Проблеми з правами**: Переконайтеся, що `web/sites/default/files` доступний для запису

4. **Видно тестові теми**: Додайте до settings.php:
   ```php
   $settings['extension_discovery_scan_tests'] = FALSE;
   ```

5. **Очистити базу даних для чистого встановлення**:
   ```bash
   lando drush sql-drop -y
   ```

## Ліцензія

GPL-2.0-or-later

## Репозиторій

https://github.com/kindrakevich-agency/constructor
