<?php

namespace Drupal\consumer_base_url\HttpKernel;

use Drupal\consumer_base_url\BaseUrlProvider;
use Drupal\Core\Render\BubbleableMetadata;
use Drupal\Core\RouteProcessor\OutboundRouteProcessorInterface;
use Symfony\Component\Routing\Route;

/**
 * Processes outbound routes for consumers.
 *
 * Helps to generate correct URLs in backend for viewing of
 * published/unpublished articles in frontend. That's important for editorial
 * workflow.
 */
class ConsumerRouteProcessor implements OutboundRouteProcessorInterface {

  /**
   * Route option key to pass information to outbound path processor.
   *
   * @see \Drupal\consumer_base_url\HttpKernel\ConsumerPathProcessor::processOutbound()
   */
  public const ROUTE_OPTION = '\Drupal\consumer_base_url\HttpKernel\ConsumerRouteProcessor:isConsumerRoute';

  public function __construct(
    protected BaseUrlProvider $baseUrlProvider,
  ) {
  }

  /**
   * {@inheritdoc}
   */
  public function processOutbound($route_name, Route $route, array &$parameters, ?BubbleableMetadata $bubbleable_metadata = NULL) {
    $route->setOption(static::ROUTE_OPTION, in_array($route_name, $this->baseUrlProvider->getConsumerRoutes(), TRUE));
  }

}
