#!/bin/bash

# Contact Slack Test Runner Script
# Usage: ./run-tests.sh [unit|kernel|functional|all]

set -e

PHPUNIT_BIN="vendor/bin/phpunit"
MODULE_PATH="web/modules/contrib/contact_slack"
PHPUNIT_CONFIG="${MODULE_PATH}/phpunit.xml.dist"

# Colors for output
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

# Check if phpunit exists
if [ ! -f "$PHPUNIT_BIN" ]; then
    echo -e "${RED}Error: PHPUnit not found at ${PHPUNIT_BIN}${NC}"
    echo "Please run: composer require --dev phpunit/phpunit"
    exit 1
fi

# Check if config exists
if [ ! -f "$PHPUNIT_CONFIG" ]; then
    echo -e "${RED}Error: PHPUnit config not found at ${PHPUNIT_CONFIG}${NC}"
    exit 1
fi

# Default to all tests
TEST_SUITE="${1:-all}"

echo -e "${YELLOW}Contact Slack Module - Test Runner${NC}"
echo "=================================="
echo ""

case $TEST_SUITE in
    unit)
        echo -e "${GREEN}Running Unit Tests...${NC}"
        $PHPUNIT_BIN -c $PHPUNIT_CONFIG --testsuite unit
        ;;
    kernel)
        echo -e "${GREEN}Running Kernel Tests...${NC}"
        $PHPUNIT_BIN -c $PHPUNIT_CONFIG --testsuite kernel
        ;;
    functional)
        echo -e "${GREEN}Running Functional Tests...${NC}"
        $PHPUNIT_BIN -c $PHPUNIT_CONFIG --testsuite functional
        ;;
    coverage)
        echo -e "${GREEN}Running All Tests with Coverage...${NC}"
        $PHPUNIT_BIN -c $PHPUNIT_CONFIG --coverage-html coverage
        echo -e "${GREEN}Coverage report generated in coverage/index.html${NC}"
        ;;
    all)
        echo -e "${GREEN}Running All Tests...${NC}"
        $PHPUNIT_BIN -c $PHPUNIT_CONFIG
        ;;
    *)
        echo -e "${RED}Invalid test suite: $TEST_SUITE${NC}"
        echo "Usage: $0 [unit|kernel|functional|coverage|all]"
        exit 1
        ;;
esac

echo ""
echo -e "${GREEN}Tests completed!${NC}"
