<?php

namespace Drupal\contact_slack\Service;

use Drupal\contact\MessageInterface;

/**
 * Interface for Slack notification service.
 */
interface SlackNotificationServiceInterface {

  /**
   * Send a Slack notification for a contact message.
   *
   * @param \Drupal\contact\MessageInterface $message
   *   The contact message entity.
   *
   * @return bool
   *   TRUE if the notification was sent successfully, FALSE otherwise.
   */
  public function sendContactNotification(MessageInterface $message): bool;

  /**
   * Send a test message to Slack.
   *
   * @param string $channel
   *   The Slack channel to send the test message to.
   *
   * @return bool
   *   TRUE if the test message was sent successfully, FALSE otherwise.
   */
  public function sendTestMessage(string $channel = ''): bool;

  /**
   * Format a contact message for Slack.
   *
   * @param \Drupal\contact\MessageInterface $message
   *   The contact message entity.
   *
   * @return array<string, mixed>
   *   The formatted Slack message data.
   */
  public function formatMessage(MessageInterface $message): array;

  /**
   * Validate a Slack webhook URL.
   *
   * @param string $webhook_url
   *   The webhook URL to validate.
   *
   * @return bool
   *   TRUE if the webhook URL is valid, FALSE otherwise.
   */
  public function validateWebhookUrl(string $webhook_url): bool;

}
