<?php

namespace Drupal\contact_slack;

/**
 * Trait for validating Slack webhook URLs.
 */
trait SlackWebhookValidationTrait {

  /**
   * Validates a Slack webhook URL format.
   *
   * @param string $url
   *   The webhook URL to validate.
   *
   * @return bool
   *   TRUE if the URL is a valid Slack webhook URL, FALSE otherwise.
   */
  protected function validateSlackWebhookUrl(string $url): bool {
    $pattern = '/^https:\/\/hooks\.slack\.com\/services\/[A-Z0-9]+\/[A-Z0-9]+\/[a-zA-Z0-9]+$/';
    return (bool) preg_match($pattern, $url);
  }

}
