# Contact Slack Tests

This directory contains automated tests for the Contact Slack module.

## Test Types

### Unit Tests (`tests/src/Unit/`)
Unit tests test individual classes and methods in isolation using mocks.

- **SlackNotificationServiceTest.php** - Tests for the main notification service
- **SlackWebhookValidationTraitTest.php** - Tests for webhook URL validation

### Kernel Tests (`tests/src/Kernel/`)
Kernel tests run in a minimal Drupal environment with database support.

- **ContactFormSlackFormTest.php** - Tests for third-party settings storage
- **ContactSlackModuleTest.php** - Tests for module hooks and integration

### Functional Tests (`tests/src/Functional/`)
Functional tests run in a full Drupal environment with browser simulation.

- **ContactSlackSettingsFormTest.php** - Tests for global settings form
- **ContactFormSlackIntegrationTest.php** - Tests for per-form configuration

## Running Tests

### All Tests
```bash
vendor/bin/phpunit -c web/modules/contrib/contact_slack/phpunit.xml.dist
```

### Unit Tests Only
```bash
vendor/bin/phpunit -c web/modules/contrib/contact_slack/phpunit.xml.dist --testsuite unit
```

### Kernel Tests Only
```bash
vendor/bin/phpunit -c web/modules/contrib/contact_slack/phpunit.xml.dist --testsuite kernel
```

### Functional Tests Only
```bash
vendor/bin/phpunit -c web/modules/contrib/contact_slack/phpunit.xml.dist --testsuite functional
```

### Specific Test File
```bash
vendor/bin/phpunit web/modules/contrib/contact_slack/tests/src/Unit/SlackNotificationServiceTest.php
```

### With Coverage Report
```bash
vendor/bin/phpunit -c web/modules/contrib/contact_slack/phpunit.xml.dist --coverage-html coverage
```

## Requirements

- PHPUnit 11.x (included in drupal/core-dev)
- PHP 8.1 or higher
- Drupal 10.0+ or Drupal 11.0+

## Configuration

Edit `phpunit.xml.dist` to customize:
- `SIMPLETEST_BASE_URL` - Your local site URL
- `SIMPLETEST_DB` - Database connection string
- `BROWSERTEST_OUTPUT_DIRECTORY` - Where to save test output

## Test Coverage

Current test coverage includes:
- ✅ Slack notification service (all methods)
- ✅ Webhook URL validation
- ✅ Third-party settings storage
- ✅ Form validation
- ✅ Message formatting
- ✅ Multiple webhook URLs
- ✅ Field selection
- ✅ System information inclusion
- ✅ Error handling
- ✅ Hook implementations

## Writing New Tests

When adding new features, ensure:
1. Add unit tests for new service methods
2. Add kernel tests for configuration/storage
3. Add functional tests for form interactions
4. Update this README with new test files
