<?php

namespace Drupal\content_archiver\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class SettingsForm extends ConfigFormBase {
	protected function getEditableConfigNames() {
		return ['content_archiver.settings'];
	}

	public function getFormId() {
		return 'content_archiver_settings_form';
	}

	public function buildForm(array $form, FormStateInterface $form_state) {
		$config = $this->config('content_archiver.settings');

		$form['expiration_field'] = [
			'#type' => 'textfield',
			'#title' => $this->t('Expiration field machine name'),
			'#description' => $this->t('Machine name of a date/datetime field on nodes that stores the expiration date (e.g., field_expiration).'),
			'#default_value' => $config->get('expiration_field') ?: 'field_expiration',
			'#required' => TRUE,
		];

		$form['notify_author'] = [
			'#type' => 'checkbox',
			'#title' => $this->t('Notify author when unpublished'),
			'#default_value' => (bool) $config->get('notify_author'),
		];

		$form['notification_subject'] = [
			'#type' => 'textfield',
			'#title' => $this->t('Notification email subject'),
			'#default_value' => $config->get('notification_subject') ?: $this->t('Your content has been archived'),
			'#states' => [
				'visible' => [
					':input[name="notify_author"]' => ['checked' => TRUE],
				],
			],
		];

		$form['notification_body'] = [
			'#type' => 'textarea',
			'#title' => $this->t('Notification email body'),
			'#default_value' => $config->get('notification_body') ?: $this->t('Hello [author:name],\n\nYour content "[node:title]" has been archived as of [date].'),
			'#description' => $this->t('Available tokens: [author:name], [node:title], [date]'),
			'#states' => [
				'visible' => [
					':input[name="notify_author"]' => ['checked' => TRUE],
				],
			],
		];

		$form['batch_size'] = [
			'#type' => 'number',
			'#title' => $this->t('Cron batch size'),
			'#default_value' => (int) ($config->get('batch_size') ?? 25),
			'#min' => 1,
			'#max' => 500,
			'#description' => $this->t('Number of nodes to enqueue per cron run.'),
		];

		return parent::buildForm($form, $form_state);
	}

	public function submitForm(array &$form, FormStateInterface $form_state) {
		parent::submitForm($form, $form_state);
		$this->configFactory()->getEditable('content_archiver.settings')
			->set('expiration_field', $form_state->getValue('expiration_field'))
			->set('notify_author', (bool) $form_state->getValue('notify_author'))
			->set('notification_subject', $form_state->getValue('notification_subject'))
			->set('notification_body', $form_state->getValue('notification_body'))
			->set('batch_size', (int) $form_state->getValue('batch_size'))
			->save();
	}
} 