<?php

namespace Drupal\content_completeness_index\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\content_completeness_index\Service\CompletenessIndexPreviewService;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * Controller for content completeness index preview endpoint.
 */
class CompletenessPreviewController extends ControllerBase {

  /**
   * Constructs a CompletenessPreviewController object.
   *
   * @param \Drupal\content_completeness_index\Service\CompletenessIndexPreviewService $previewService
   *   The preview service.
   */
  public function __construct(
    private readonly CompletenessIndexPreviewService $previewService
  ) {}

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('content_completeness_index.preview_service')
    );
  }

  /**
   * Returns a preview score based on field values.
   *
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   The request object.
   * @param string $entity_type
   *   The entity type ID.
   * @param string $bundle
   *   The bundle name.
   *
   * @return \Symfony\Component\HttpFoundation\JsonResponse
   *   JSON response with score and missing fields.
   */
  public function preview(Request $request, string $entity_type, string $bundle): JsonResponse {
    // Get field values from request.
    $data = json_decode($request->getContent(), TRUE);
    $field_states = $data['fields'] ?? [];

    // Calculate preview score.
    $result = $this->previewService->calculatePreview($entity_type, $bundle, $field_states);

    return new JsonResponse($result);
  }

}
