# Content Completeness Index

This module calculates and displays a "content completeness index" per entity
(e.g., Node) based on configured field weights, without using a Drupal field
type.

## Features

- Enable the completeness index per content type (bundle) from the content type
  configuration screen.
- Provide a "Completeness Index" configuration tab per bundle that lists all
  fields and allows assigning a weight (default 1).
- Automatically calculate and store the index value for each revision in a
  custom table.
- Display the index using a Drupal 11 Component (no field formatter).
- Provide an admin batch UI and Drush command to backfill missing or outdated
  indices.
- Optional Field Group + Simple Multistep integration (enable the
  `content_completeness_index_field_group` submodule).
- Meet Drupal 11 coding standards and best practices (Attribute-based Hooks,
  Dependency Injection, Config API, and Typed Data).

## Usage

### Configuration

1. Navigate to Structure > Content types > [Your content type] > Completeness
   Index.
2. Configure weights for each field (default weight is 1).
3. Save the configuration.

### Display

Use the component in your Twig templates:

```twig
{{ component('content_completeness_index', { entity: node }) }}
```

### Drush Commands

Rebuild indices for all content types or a specific bundle. The command now
uses per-bundle rebuild queues; by default it enqueues and processes the queue
immediately, but you can opt to only enqueue by adding `--queue-only`.

```bash
drush content-completeness:rebuild [bundle]
```

Each enabled bundle has its own queue worker named
`content_completeness_index_rebuild:node.BUNDLE`. You can process them manually
with `drush queue:run content_completeness_index_rebuild:node.article`, allow
cron to process them, or let the rebuild command run them synchronously.

## Requirements

- Drupal 11.1+
- PHP 8.2+

## Permissions

- **Administer content completeness index**: Configure and recalculate
  completeness indices.
