# Content Completeness Index Conditional Validation

This submodule enables conditional field weighting for the Content
Completeness Index (CCI) by reusing Field Validation rule sets. It provides a
per-field UI that lets site builders define conditional weights using the
existing Field Validation condition builder.

## Usage

1. Enable the `Content Completeness Index Conditional Validation` module (and
   its dependencies).
2. Navigate to `admin/structure/types/manage/{content_type}/completeness-index`
   and use the *Conditional weights* link next to each field to manage its
   conditional rules.
3. Within the rule set UI, add **CCI conditional weight** rules. Each rule lets
   you specify the weight to apply and the condition under which it should be
   used.
4. When a condition matches, the configured weight replaces the static weight
   from the Completeness Index configuration during score calculation.

## Notes

- Rule sets are stored as Field Validation configuration entities but are
  isolated from standard validation flows.
- Rule order is significant; the first matching rule determines the applied
  weight.
- If no rule matches, the original static weight from the Completeness Index
  configuration is used.
