<?php

namespace Drupal\content_completeness_index_conditional_validation\Plugin\FieldValidationRule;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\field_validation\FieldValidationRuleInterface;

/**
 * Additional methods exposed by conditional weight rules.
 */
interface ConditionalWeightRuleInterface extends FieldValidationRuleInterface {

  /**
   * Checks if the rule applies to the provided entity.
   *
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity being evaluated.
   *
   * @return bool
   *   TRUE if the condition is met.
   */
  public function applies(ContentEntityInterface $entity): bool;

  /**
   * Returns the weight to use when the rule matches.
   *
   * @return float
   *   The conditional weight value.
   */
  public function getTargetWeight(): float;

}
