<?php

namespace Drupal\content_completeness_index_conditional_validation\Service;

use Drupal\content_completeness_index\Service\ConditionalWeightEvaluatorInterface;
use Drupal\content_completeness_index_conditional_validation\Plugin\FieldValidationRule\ConditionalWeightRuleInterface;
use Drupal\Core\Entity\ContentEntityInterface;

/**
 * Resolves conditional weights using Field Validation rule sets.
 */
class ConditionalWeightEvaluator implements ConditionalWeightEvaluatorInterface {

  /**
   * Rule set manager.
   *
   * @var \Drupal\content_completeness_index_conditional_validation\Service\ConditionalWeightRuleSetManager
   */
  protected ConditionalWeightRuleSetManager $ruleSetManager;

  /**
   * Constructs the evaluator.
   */
  public function __construct(ConditionalWeightRuleSetManager $rule_set_manager) {
    $this->ruleSetManager = $rule_set_manager;
  }

  /**
   * {@inheritdoc}
   */
  public function getEffectiveWeight(ContentEntityInterface $entity, string $field_name, float $base_weight): float {
    $ruleset = $this->ruleSetManager->loadRuleSet($entity->getEntityTypeId(), $entity->bundle(), $field_name);
    if (!$ruleset) {
      return $base_weight;
    }

    $target_field = $this->ruleSetManager->getTargetField($ruleset);
    if ($target_field !== $field_name) {
      return $base_weight;
    }

    foreach ($ruleset->getFieldValidationRules() as $rule) {
      if (!$rule instanceof ConditionalWeightRuleInterface) {
        continue;
      }
      if ($rule->applies($entity)) {
        return $rule->getTargetWeight();
      }
    }

    return $base_weight;
  }

}
