<?php

namespace Drupal\content_completeness_index_field_group;

use Drupal\content_completeness_index_field_group\Service\FieldGroupingHelper;
use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderBase;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Overrides services when the Field Group integration module is enabled.
 */
class ContentCompletenessIndexFieldGroupServiceProvider extends ServiceProviderBase {

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container) {
    if ($container->hasDefinition('content_completeness_index.field_group_helper')) {
      $container->getDefinition('content_completeness_index.field_group_helper')
        ->setClass(FieldGroupingHelper::class)
        ->setArguments([
          new Reference('entity_display.repository'),
        ]);
    }
  }

}
