<?php

namespace Drupal\content_completeness_index\Component;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\RevisionableInterface;
use Drupal\content_completeness_index\Service\CompletenessIndexStorage;

/**
 * Drupal 11 Component for displaying content completeness index.
 */
final class ContentCompletenessComponent {

  /**
   * Constructs a ContentCompletenessComponent object.
   *
   * @param \Drupal\content_completeness_index\Service\CompletenessIndexStorage $storage
   *   The completeness index storage service.
   */
  public function __construct(
    private readonly CompletenessIndexStorage $storage,
  ) {}

  /**
   * Builds the component render array.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity to display the score for.
   *
   * @return array
   *   The render array.
   */
  public function build(EntityInterface $entity): array {
    $entity_type = $entity->getEntityTypeId();
    $revision_id = $entity instanceof RevisionableInterface ? $entity->getRevisionId() : NULL;

    $score = $revision_id ? $this->storage->getScoreForRevision($entity_type, $revision_id) : 0;

    return [
      '#theme' => 'content_completeness_index',
      '#score' => $score,
      '#entity' => $entity,
      '#attached' => [
        'library' => [
          'content_completeness_index/completeness_index',
        ],
      ],
    ];
  }

}
