<?php

namespace Drupal\content_completeness_index\Plugin\Derivative;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Drupal\content_completeness_index\Service\CompletenessConfigManager;
use Drupal\content_completeness_index\Service\CompletenessRebuildScheduler;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Derives queue worker definitions per enabled bundle.
 */
class CompletenessRebuildQueueDeriver extends DeriverBase implements ContainerDeriverInterface {

  use StringTranslationTrait;

  /**
   * Constructs the deriver.
   */
  public function __construct(
    protected readonly CompletenessConfigManager $configManager,
  ) {}

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, $base_plugin_id) {
    return new static(
      $container->get('content_completeness_index.config_manager'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition) {
    $this->derivatives = [];
    foreach ($this->configManager->getEnabledBundles() as $bundle) {
      $derivative_id = sprintf('%s.%s', CompletenessRebuildScheduler::ENTITY_TYPE, $bundle);
      $definition = $base_plugin_definition;
      $definition['title'] = $this->t('Content completeness rebuild (@bundle)', ['@bundle' => $bundle]);
      $definition['cache_tags'] = ['content_completeness_index.bundle_list'];
      $this->derivatives[$derivative_id] = $definition;
    }

    return $this->derivatives;
  }

}
