<?php

namespace Drupal\content_completeness_index\Service;

use Drupal\Core\Entity\ContentEntityInterface;

/**
 * Defines the interface for conditional weight evaluators.
 */
interface ConditionalWeightEvaluatorInterface {

  /**
   * Calculates the effective weight for an entity field.
   *
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity being scored.
   * @param string $field_name
   *   The target field machine name.
   * @param float $base_weight
   *   The configured static weight for the field.
   *
   * @return float
   *   The weight to use when calculating completeness.
   */
  public function getEffectiveWeight(ContentEntityInterface $entity, string $field_name, float $base_weight): float;

}
