<?php

namespace Drupal\content_completeness_index\Service;

/**
 * Provides field grouping metadata used by completeness UI components.
 */
interface FieldGroupingHelperInterface {

  /**
   * Builds grouped and ungrouped field collections for a bundle.
   *
   * @param string $entity_type
   *   The entity type ID.
   * @param string $bundle
   *   The bundle machine name.
   * @param array $fields
   *   List of field metadata arrays with at least name/label/weight.
   *
   * @return array
   *   Array with 'groups' and 'ungrouped' keys.
   */
  public function groupFields(string $entity_type, string $bundle, array $fields): array;

  /**
   * Returns metadata describing configured multi-step form groups.
   *
   * @param string $entity_type
   *   The entity type ID.
   * @param string $bundle
   *   The bundle machine name.
   *
   * @return array
   *   Array with 'is_multistep' and 'steps' keys.
   */
  public function getFormStepMetadata(string $entity_type, string $bundle): array;

}
