<?php

namespace Drupal\content_completeness_index\Service;

use Drupal\Core\Entity\ContentEntityInterface;

/**
 * Default evaluator that keeps the configured weight unchanged.
 */
class NullConditionalWeightEvaluator implements ConditionalWeightEvaluatorInterface {

  /**
   * {@inheritdoc}
   */
  public function getEffectiveWeight(ContentEntityInterface $entity, string $field_name, float $base_weight): float {
    return $base_weight;
  }

}
