<?php

namespace Drupal\content_completeness_index\Service;

/**
 * No-op implementation used when field group integration is disabled.
 */
class NullFieldGroupingHelper implements FieldGroupingHelperInterface {

  /**
   * {@inheritdoc}
   */
  public function groupFields(string $entity_type, string $bundle, array $fields): array {
    return [
      'groups' => [],
      'ungrouped' => $fields,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormStepMetadata(string $entity_type, string $bundle): array {
    return [
      'is_multistep' => FALSE,
      'steps' => [],
    ];
  }

}
