<?php

namespace Drupal\content_completeness_score\Component;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Render\Attribute\Component;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\content_completeness_score\Service\CompletenessScoreStorage;

/**
 * Drupal 11 Component for displaying content completeness score.
 */
#[Component(
  id: 'content_completeness_score',
  label: new TranslatableMarkup('Content Completeness Score')
)]
final class ContentCompletenessComponent {

  /**
   * Constructs a ContentCompletenessComponent object.
   *
   * @param \Drupal\content_completeness_score\Service\CompletenessScoreStorage $storage
   *   The completeness score storage service.
   */
  public function __construct(
    private readonly CompletenessScoreStorage $storage
  ) {}

  /**
   * Builds the component render array.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity to display the score for.
   *
   * @return array
   *   The render array.
   */
  public function build(EntityInterface $entity): array {
    $entity_type = $entity->getEntityTypeId();
    $revision_id = $entity->getRevisionId();

    $score = $this->storage->getScoreForRevision($entity_type, $revision_id);

    return [
      '#theme' => 'content_completeness_score',
      '#score' => $score,
      '#entity' => $entity,
      '#attached' => [
        'library' => [
          'content_completeness_score/completeness_score',
        ],
      ],
    ];
  }

}
