# Content Completeness Score

This module calculates and displays a "content completeness score" per entity (e.g., Node) based on configured field weights, without using a Drupal field type.

## Features

- Enable the completeness score per content type (bundle) from the content type configuration screen
- Provide a "Completeness Score" configuration tab per bundle that lists all fields and allows assigning a weight (default 1)
- Automatically calculate and store the score for each revision in a custom table
- Display the score using a Drupal 11 Component (no field formatter)
- Provide an admin batch UI and Drush command to backfill missing or outdated scores
- Meet Drupal 11 coding standards and best practices (Attribute-based Hooks, Dependency Injection, Config API, and Typed Data)

## Usage

### Configuration

1. Navigate to Structure > Content types > [Your content type] > Completeness Score
2. Configure weights for each field (default weight is 1)
3. Save the configuration

### Display

Use the component in your Twig templates:

```twig
{{ component('content_completeness_score', { entity: node }) }}
```

### Drush Commands

Rebuild scores for all content types or a specific bundle:

```bash
drush content-completeness:rebuild [bundle]
```

## Requirements

- Drupal 11.1+
- PHP 8.2+

## Permissions

- **Administer content completeness score**: Configure and recalculate completeness scores
