(function (Drupal, once) {
  'use strict';

  Drupal.behaviors.contentCompletenessBundleConfig = {
    attach: function (context) {
      const fields = once(
        'content-completeness-bundle-config-field',
        '.content-completeness-field',
        context,
      );

      fields.forEach(function (field) {
        const checkbox = field.querySelector('input.content-completeness-include');
        if (!checkbox) {
          return;
        }

        const updateState = function () {
          field.classList.toggle('is-disabled', !checkbox.checked);
        };

        updateState();
        checkbox.addEventListener('change', updateState);
      });
    },
  };
})(Drupal, once);
