<?php

namespace Drupal\content_completeness_score\Access;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\node\NodeTypeInterface;

/**
 * Controls access to the completeness score bundle configuration route.
 */
class CompletenessBundleAccessCheck {

  /**
   * Constructs the access checker.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   *   The config factory.
   */
  public function __construct(
    private readonly ConfigFactoryInterface $configFactory,
  ) {}

  /**
   * Determines access to the bundle configuration form.
   *
   * @param \Drupal\node\NodeTypeInterface $node_type
   *   The node type bundle.
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The current user.
   *
   * @return \Drupal\Core\Access\AccessResult
   *   The access result.
   */
  public function access(NodeTypeInterface $node_type, AccountInterface $account): AccessResult {
    $config = $this->configFactory->get("content_completeness_score.settings.{$node_type->id()}");
    $enabled = (bool) ($config->get('enabled') ?? FALSE);

    $result = AccessResult::allowedIf($enabled);
    $result->addCacheableDependency($node_type);
    $result->addCacheableDependency($config);

    return $result;
  }

}
