The **Content First** module provides a simple tool for viewing the plain text content of any node without design, media, or layout distractions. It helps content teams, editors, and designers focus on what matters most: the content itself.

Whether you're drafting, reviewing, or rethinking your site’s messaging, this module supports a true “content-first” approach by giving you a clean, layout-free version of your page.

### Features

#### Content Tab

The content first module adds a new tab to every node page. That tab shows a clean, structured text version of the page content.

From this tab, you can:

- View all text content (without layout noise): Markdown and simple HTML formats
- Copy it with one click
- Download it as plain text: Markdown and simple HTML

No configuration. No views to build. Just access to the content.

#### Markdown content visualization
![Markdown visualization](https://www.drupal.org/files/project-images/content_first-markdown.png)

#### (simple) HTML content visualization
![HTML visualization](https://www.drupal.org/files/project-images/content_first-html.png)

#### Content Export

The module allows to select multiple content and download them all at once into a .zip so yo can process the data elsewhere.

![Content first download zip](https://www.drupal.org/files/project-images/content_first-download_zip.png)

### Use cases:

- Content strategy and copywriting review sessions (human or AI)
- Pre-design content validation
- Content audits or UX writing sprints
- Minimal reading interface for accessibility reviews

### Post-Installation
Install and enable the module.

- Assign the View Content First tab permission to the appropriate roles.
- Navigate to any node page — you'll see a new "Content First" tab.
- Click the tab to view the stripped-down, text-only version of the node.
- No additional configuration is needed.

### Additional Requirements
Requires only Drupal core’s Node module.

No contributed module dependencies.

### Recommended modules/libraries
(None at this time — fully standalone)
Future versions may include optional integrations.

### Supporting this Module
This module is developed and maintained by Metadrop, a Drupal consultancy passionate about content strategy and sustainable digital platforms.

### Community Documentation
Coming soon — we welcome contributions!
Feel free to open issues, suggest improvements, or share how you’re using the module.

