<?php

namespace Drupal\content_first\Controller;

use Drupal\content_first\Builder\ContentFirstBuilderInterface;
use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Returns responses for Entity Mesh note routes.
 */
abstract class EntityController extends ControllerBase {

  /**
   * The content first builder.
   *
   * @var \Drupal\content_first\Builder\ContentFirstBuilderInterface
   */
  protected ContentFirstBuilderInterface $contentFirstBuilder;

  /**
   * Constructor.
   *
   * @param \Drupal\content_first\Builder\ContentFirstBuilderInterface $content_first_builder
   *   The content first builder.
   */
  final public function __construct(ContentFirstBuilderInterface $content_first_builder) {
    $this->contentFirstBuilder = $content_first_builder;
  }

  /**
   * {@inheritdoc}
   */
  final public static function create(ContainerInterface $container) {
    return new static(
      $container->get('content_first.builder'),
    );
  }

}
