<?php

namespace Drupal\content_first\Builder;

use Drupal\content_first\RenderedContent;
use Drupal\Core\Entity\ContentEntityInterface;

/**
 * Allow classes to render plain text from a content entity.
 */
interface ContentFirstBuilderInterface {

  /**
   * Renders the content.
   *
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The content entity.
   * @param string $view_mode
   *   The view mode.
   *
   * @return \Drupal\content_first\RenderedContent|null
   *   The rendered content, if it could be rendered.
   */
  public function buildContent(ContentEntityInterface $entity, string $view_mode) : ?RenderedContent;

}
