<?php

namespace Drupal\content_language_no_outbound\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure the  language negotiation method for this site.
 *
 * @internal
 */
class NegotiationContentEntityForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'content_language_no_outbound_negotiation_configuration_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['content_language_no_outbound.negotiation'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('content_language_no_outbound.negotiation');

    $form['content_entity_path_names'] = [
      '#title' => $this->t('Outbound entity path names'),
      '#description' => $this->t("Enter one entity path name per line (as defined in the \"links\" of an entity's class annotation, e.g. \"edit-form\") to add the language_content_entity query parameter to outbound URLs leading to these paths."),
      '#type' => 'textarea',
      '#default_value' => $config->get('content_entity_path_names'),
      '#config_target' => 'content_language_no_outbound.negotiation:content_entity_path_names',
    ];

    $form_state->setRedirect('language.negotiation');

    return parent::buildForm($form, $form_state);
  }

}
