<?php

namespace Drupal\content_moderation_tabs\Controller;

use Drupal\content_moderation_tabs\ModeratedNodeListBuilder;
use Drupal\Core\Controller\ControllerBase;

/**
 * Defines a controller to list soft-deleted nodes.
 * 
 * This is a fallback for the rare case of sites having Views module disabled.
 */
class ModeratedContentController extends ControllerBase {

  /**
   * Provides the listing page for moderated nodes.
   *
   * @return array
   *   A render array as expected by
   *   \Drupal\Core\Render\RendererInterface::render().
   */
  public function nodeListing($state = 'trash') {
    $entity_type = $this->entityTypeManager()->getDefinition('node');

    return $this->entityTypeManager()->createHandlerInstance(ModeratedNodeListBuilder::class, $entity_type, $state)->render();
  }

}
