<?php

/**
 * @file
 * Script migrates content reminders from ConfigType to ContentType.
 */

use Drupal\content_reminders\ContentReminderInterface;
use Drupal\Core\Datetime\DrupalDateTime;

/**
 * @file
 * Script migrates content reminders from ConfigType to ContentType.
 */

/**
 * This function converts all content reminders from ConfigType to Content Type.
 *
 * @return void
 *   There is no return value.
 *
 * @throws \Drupal\Component\Plugin\Exception\InvalidPluginDefinitionException
 * @throws \Drupal\Component\Plugin\Exception\PluginNotFoundException
 * @throws \Drupal\Core\Entity\EntityStorageException
 */
function migrate_content_reminders(): void {
  $entity_type_manager = \Drupal::entityTypeManager();
  $storage = $entity_type_manager->getStorage('content_reminder');
  $content_reminders = $storage->loadMultiple();

  foreach ($content_reminders as $content_reminder) {
    if ($content_reminder instanceof ContentReminderInterface) {
      $emails = $content_reminder->getEmails();
      $message = $content_reminder->getMessage();
      $node_id = $content_reminder->getNodeId();
      $date_time = DrupalDateTime::createFromTimestamp($content_reminder->getDateTime());
      $status = $content_reminder->status();
      $label = $node_id . ' content reminder';

      printf("Emails: %s\nNode ID: %d\nStatus %d\nLabel: %s\nmessage: %s\nDateTime: %s\n\n",
        $emails,
        $node_id,
        $status,
        $label,
        $message,
        $date_time->format('Y-m-d H:i:s'));
    }

    /** @var \Drupal\content_reminders\ReminderEntity $reminder_entity */
    $reminder_entity = $entity_type_manager
      ->getStorage('reminder_entity')
      ->create();

    $reminder_entity->set('label', $label);
    $reminder_entity->set('status', $status);
    $reminder_entity->set('emails', $emails);
    $reminder_entity->set('nid', $node_id);
    $reminder_entity->set('date_time', $date_time->getTimestamp());
    $reminder_entity->set('message', $message);
    $reminder_entity->save();

    $content_reminder->delete();
  }
}
