<?php

namespace Drupal\content_reminders\Entity;

use Drupal\Core\Entity\ContentEntityBase;
use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Field\BaseFieldDefinition;

/**
 * Defines the Content Reminder.
 *
 * @ContentEntityType(
 *   id = "reminder_entity",
 *   label = @Translation("Reminder Entity"),
 *   label_collection = @Translation("Reminder Entities"),
 *   label_singular = @Translation("Reminder Entity"),
 *   label_plural = @Translation("Reminder Entities"),
 *   label_count = @PluralTranslation(
 *     singular = "@count Reminder Entity",
 *     plural = "@count Reminder Entities",
 *   ),
 *   base_table = "content_reminder",
 *   handlers = {
 *     "list_builder" = "Drupal\content_reminders\ContentRemindersListBuilder",
 *     "form" = {
 *       "add" = "Drupal\content_reminders\Form\ReminderEntityForm",
 *       "edit" = "Drupal\content_reminders\Form\ReminderEntityForm",
 *       "delete" = "Drupal\Core\Entity\ContentEntityDeleteForm",
 *     }
 *   },
 *   config_prefix = "reminder_entity",
 *   admin_permission = "manage content reminders",
 *   links = {
 *     "collection" = "/admin/content/content_reminders",
 *     "add-form" = "/admin/content/content_reminders/add",
 *     "preview-page" = "/admin/content/content_reminders/{reminder_entity}/preview",
 *     "edit-form" = "/admin/content/content_reminders/{reminder_entity}",
 *     "delete-form" = "/admin/content/content_reminders/{reminder_entity}/delete"
 *   },
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid",
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "nid",
 *     "uid",
 *     "emails",
 *     "date_time",
 *     "message"
 *   }
 * )
 */
class ReminderEntity extends ContentEntityBase implements ContentEntityInterface {

  /**
   * Create the base field definitions for the Reminder entity.
   *
   * @param \Drupal\Core\Entity\EntityTypeInterface $entity_type
   *   The entity type definition.
   *
   * @return array
   *   An array of base field definitions.
   */
  public static function baseFieldDefinitions(EntityTypeInterface $entity_type) {
    $fields['id'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('id'))
      ->setDescription(t('The ID of the Content Reminder.'));

    $fields['uuid'] = BaseFieldDefinition::create('uuid')
      ->setLabel(t('uuid'))
      ->setDescription(t('The UUID of the Content Reminder.'))
      ->setReadOnly(TRUE);

    $fields['uid'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('uid'))
      ->setDescription(t('The ID of the Content Reminder author.'));

    $fields['label'] = BaseFieldDefinition::create('string')
      ->setLabel(t('label'))
      ->setDescription(t('The label of the Content Reminder.'));

    $fields['status'] = BaseFieldDefinition::create('boolean')
      ->setLabel(t('status'))
      ->setDescription(t('The status of the Content Reminder.'));

    $fields['nid'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('nid'))
      ->setDescription(t('The node id of the Content Reminder.'));

    $fields['emails'] = BaseFieldDefinition::create('string')
      ->setLabel(t('emails'))
      ->setDescription(t('The email address of the Content Reminder.'));

    $fields['message'] = BaseFieldDefinition::create('string')
      ->setLabel(t('message'))
      ->setDescription(t('The message of the Content Reminder.'));

    $fields['date_time'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('datetime'))
      ->setDescription(t('The date time of the Content Reminder.'));

    return $fields;
  }

}
