<?php

namespace Drupal\content_templates\Form;

use Drupal\Core\Entity\ContentEntityDeleteForm;

/**
 * Provides a form for deleting content template entities.
 *
 * @ingroup content_template
 */
class ContentTemplateDeleteForm extends ContentEntityDeleteForm {

  /**
   * {@inheritdoc}
   */
  public function getQuestion() {
    return $this->t('Are you sure you do not want to use "%label" as template anymore?', [
      '%label' => $this->getEntity()->label() ?? $this->getEntity()->id(),
    ]);
  }

  /**
   * {@inheritdoc}
   */
  public function getConfirmText() {
    return $this->t('Do not use as template');
  }

  /**
   * {@inheritdoc}
   */
  protected function getDeletionMessage() {
    $entity = $this->getEntity();
    return $this->t('The %label was removed from template list.', [
      '%label' => $entity->label() ?? $entity->id(),
    ]);
  }

}
