(function ($, Drupal, once) {
  Drupal.behaviors.tableOfContents = {
    attach: function (context, settings) {
      const headings = $('.node .field--name-body h2, .node .field--name-body h3');
      const tocLinks = $('.toc-list a', context);
      const scrollOffset = 100;

      if (!headings.length || !tocLinks.length) return;

      // Assign index to each TOC link and handle clicks.
      const tocLinksOnce = once('tocScroll', tocLinks, context);
      tocLinksOnce.forEach((link, i) => {
        $(link).attr('data-index', i);

        $(link).on('click', function (e) {
          e.preventDefault();
          const index = parseInt($(this).attr('data-index'));
          const target = headings.eq(index);

          if (target.length) {
            const targetPosition = target.offset().top - scrollOffset;

            $('html, body').animate({ scrollTop: targetPosition }, 300);

            tocLinks.removeClass('active bold italic');

            const activeLink = $(this);
            activeLink.addClass('active');

            if (activeLink.closest('li').hasClass('toc-h2')) {
              activeLink.addClass('bold');
            } else if (activeLink.closest('li').hasClass('toc-h3')) {
              activeLink.addClass('italic');
            }

            // Highlight TOC block border
            const tocBlock = $('.block-table-of-contents-block');
            tocBlock.addClass('active-toc');
          }
        });
      });

      // Attach scroll listener only once
      const windowOnce = once('tocScrollWindow', window, context);
      windowOnce.forEach(win => {
        $(win).on('scroll', Drupal.debounce(onScroll, 50));
      });

      /**
       * Scroll-based detection for active TOC link
       */
      function onScroll() {
        const scrollPosition = $(window).scrollTop();
        const viewportHeight = $(window).height();
        const midPoint = scrollPosition + viewportHeight / 3;

        let currentIndex = 0;

        headings.each(function (i) {
          const headingTop = $(this).offset().top;
          if (headingTop - scrollOffset < midPoint) {
            currentIndex = i;
          }
        });

        tocLinks.removeClass('active bold italic');

        const activeLink = tocLinks.eq(currentIndex);
        activeLink.addClass('active');

        if (activeLink.closest('li').hasClass('toc-h2')) {
          activeLink.addClass('bold');
        } else if (activeLink.closest('li').hasClass('toc-h3')) {
          activeLink.addClass('italic');
        }

        const tocBlock = $('.block-table-of-contents-block');
        if (activeLink.length) {
          tocBlock.addClass('active-toc');
        } else {
          tocBlock.removeClass('active-toc');
        }
      }

      onScroll();
    }
  };
})(jQuery, Drupal, once);
