(function($, Drupal, once) {
  Drupal.behaviors.tableOfContents = {
    attach: function(context, settings) {
      const headings = $('.node .field--name-body h2, .node .field--name-body h3');
      const tocLinks = $('.toc-list a', context);
      const scrollOffset = 100;
      let isClickScrolling = false;

      if (!headings.length || !tocLinks.length) return;

      // Assign index to each TOC link and handle clicks.
      const tocLinksOnce = once('tocScroll', tocLinks, context);
      tocLinksOnce.forEach((link, i) => {
        $(link).attr('data-index', i);

        $(link).on('click', function(e) {
          e.preventDefault();
          const index = parseInt($(this).attr('data-index'));
          const target = headings.eq(index);

          if (!target.length) return;

          const targetPosition = target.offset().top - scrollOffset;

          isClickScrolling = true;

          tocLinks.removeClass('active bold italic');
          const activeLink = $(this);
          activeLink.addClass('active');

          if (activeLink.closest('li').hasClass('toc-h2')) {
            activeLink.addClass('bold');
          } else if (activeLink.closest('li').hasClass('toc-h3')) {
            activeLink.addClass('italic');
          }

          $('.block-table-of-contents-block').addClass('active-toc');

          $('html, body').animate(
            { scrollTop: targetPosition },
            300,
            function() {
              setTimeout(() => {
                isClickScrolling = false;
              }, 150);
            }
          );
        });
      });

      if (!$(window).data('tocScrollAttached')) {
        $(window).on('scroll', Drupal.debounce(onScroll, 50));
        $(window).data('tocScrollAttached', true);
      }

      /**
       * Scroll-based active detection
       */
      function onScroll() {
        if (isClickScrolling) return;

        const scrollPosition = $(window).scrollTop();
        const viewportHeight = $(window).height();
        const midPoint = scrollPosition + viewportHeight / 3;

        let currentIndex = -1;

        headings.each(function(i) {
          const headingTop = $(this).offset().top;
          if (headingTop - scrollOffset < midPoint) {
            currentIndex = i;
          }
        });

        tocLinks.removeClass('active bold italic');

        if (currentIndex >= 0 && currentIndex < tocLinks.length) {
          const activeLink = tocLinks.eq(currentIndex);
          activeLink.addClass('active');

          if (activeLink.closest('li').hasClass('toc-h2')) {
            activeLink.addClass('bold');
          } else if (activeLink.closest('li').hasClass('toc-h3')) {
            activeLink.addClass('italic');
          }

          $('.block-table-of-contents-block').addClass('active-toc');
        } else {
          $('.block-table-of-contents-block').removeClass('active-toc');
        }
      }

      onScroll();
    },
  };
})(jQuery, Drupal, once);
