<?php

namespace Drupal\content_toc\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\node\Entity\NodeType;

/**
 *
 */
class ContentToCSettingsForm extends ConfigFormBase {

  /**
   *
   */
  protected function getEditableConfigNames() {
    return ['content_toc.settings'];
  }

  /**
   *
   */
  public function getFormId() {
    return 'content_toc_settings_form';
  }

  /**
   *
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('content_toc.settings');

    // Get all content types.
    $types = NodeType::loadMultiple();
    $options = [];
    foreach ($types as $type_id => $type) {
      $options[$type_id] = $type->label();
    }

    $form['content_types'] = [
      '#type' => 'checkboxes',
      '#title' => $this->t('Enable ToC for these content types'),
      '#options' => $options,
      '#default_value' => $config->get('content_types') ?? [],
    ];

    $form['field_name'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Text field to parse (e.g., body)'),
      '#default_value' => $config->get('field_name') ?? 'body',
      '#required' => TRUE,
    ];

    $form['headings'] = [
      '#type' => 'checkboxes',
      '#title' => $this->t('Heading levels to include'),
      '#options' => [
        'h2' => $this->t('H2'),
        'h3' => $this->t('H3'),
        'h4' => $this->t('H4'),
      ],
      '#default_value' => $config->get('headings') ?? ['h2' => 'h2', 'h3' => 'h3'],
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   *
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('content_toc.settings')
      ->set('content_types', array_filter($form_state->getValue('content_types')))
      ->set('field_name', $form_state->getValue('field_name'))
      ->set('headings', array_filter($form_state->getValue('headings')))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
