<?php

namespace Drupal\Tests\content_translation_access\Kernel;

use Drupal\Core\Language\Language;
use Drupal\node\Entity\Node;

/**
 * Tests AccessControlHandler.
 *
 * @coversDefaultClass \Drupal\content_translation_access\AccessControlHandler
 *
 * @group content_translation_access
 */
class AccessControlHandlerTest extends ContentTranslationAccessKernelTestBase
{

    /**
     * Modules to enable.
     *
     * @var array
     */
    protected static $modules = [
    'node',
    ];

    /**
     * Test AccessControlHandler::testAccess.
     *
     * @covers ::access()
     */
    public function testAccess()
    {

        // Create the article node type with revisions disabled.
        $user = $this->createUser(
            ['uid' => 2], [
            'administer nodes',
            'cta translate node page',
            'cta delete translation node page',
            ]
        );
        $node_en = Node::create(
            [
            'title' => $this->randomMachineName(8),
            'uid' => $user->id(),
            'type' => 'page',
            ]
        );
        $node_en->save();

        $handler = $this->accessHandler;
        /**
   * @var \Drupal\Core\Access\AccessResultInterface $access 
*/
        $access = $handler->access($node_en, 'update', $user);
        $this->assertEquals(true, $access->isAllowed());

        $access = $handler->access($node_en, 'delete', $user);
        $this->assertEquals(true, $access->isAllowed());

        $access = $handler->access($node_en, 'view', $user);
        $this->assertEquals(true, $access->isNeutral());
    }

    /**
     * Test AccessControlHandler::testCreateAccess.
     *
     * @covers ::createAccess()
     */
    public function testCreateAccess()
    {

        // Create the article node type with revisions disabled.
        $user = $this->createUser(
            ['uid' => 2], [
            'cta translate node page',
            ]
        );

        $en = new Language(['name' => 'en', 'id' => 'en']);
        $handler = $this->accessHandler;
        /**
   * @var \Drupal\Core\Access\AccessResultInterface $access 
*/
        $access = $handler->createAccess('node', 'page', $en, $user);
        $this->assertEquals(true, $access->isAllowed());
    }

    /**
     * Test AccessControlHandler::testCreateAnyAccess.
     *
     * @covers ::createAnyAccess()
     */
    public function testCreateAnyAccess()
    {

        // Create the article node type with revisions disabled.
        $user = $this->createUser(
            ['uid' => 2], [
            'administer nodes',
            'cta translate node page',
            ]
        );

        $handler = $this->accessHandler;
        /**
   * @var \Drupal\Core\Access\AccessResultInterface $access 
*/
        $access = $handler->createAnyAccess('node', 'page', $user);
        $this->assertEquals(true, $access->isAllowed());
    }

}
