<?php

namespace Drupal\Tests\content_translation_access_user\Kernel;

use Drupal\content_translation_access_user\Plugin\ContentTranslationAccess\LanguageProvider\UserLanguageProvider;
use Drupal\KernelTests\KernelTestBase;
use Drupal\language\Entity\ConfigurableLanguage;
use Drupal\Tests\user\Traits\UserCreationTrait;

/**
 * @coversDefaultClass \Drupal\content_translation_access_user\Plugin\ContentTranslationAccess\LanguageProvider\UserLanguageProvider
 *
 * @group content_translation_access
 */
class UserLanguageProviderTest extends KernelTestBase {

  use UserCreationTrait;

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();

    $this->installEntitySchema('user');
    $this->installEntitySchema('configurable_language');
    $this->installConfig([
      'system',
      'user',
      'field',
      'content_translation_access_user',
    ]);
  }

  /**
   * Modules to enable.
   *
   * @var array<string>
   */
  protected static $modules = [
    'system',
    'user',
    'field',
    'content_translation_access',
    'content_translation_access_user',
    'language',
    'content_translation',
  ];

  /**
   * Test UserLanguageProvider::getLanguages.
   *
   * @covers ::getLanguages
   */
  public function testGetLanguages() {

    $user = $this->createUser([
      'access content',
    ]);
    $en = ConfigurableLanguage::create(['id' => 'en']);
    $this->assertNotEmpty($en);

    $user->field_access_languages->set(0, $en);

    $user->save();

    $provider = new UserLanguageProvider($user);
    $languages = $provider->getLanguages();
    if (is_array($languages)) {
      $this->assertCount(1, $languages, 'Should have exactly one language.');
      foreach ($languages as $language) {
        $this->assertNotEmpty($language);
        $this->assertEquals($en->getId(), $language->getId(), 'Language IDs should match.');
        $this->assertEquals($en->getName(), $language->getName(), 'Language names should match.');
      }
    }
    else {
      $this->fail('getLanguages() should return an array.');
    }
  }

}
